/******************************************************************************
* This module contains RF4CE FSL vendor specific profile type and API definitions.
*
* Copyright (c) 2009, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
******************************************************************************/
#ifndef _FSL_PROFILE_INTERFACE_H_
#define _FSL_PROFILE_INTERFACE_H_


#include "EmbeddedTypes.h" 
#include "NwkInterface.h" 
#include "FSLProfileConf.h" 

/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/
#define gFSLProfileId_c                           0xF0
#define gFSLVendorId_c                            0x05,0x00


#define gFSLProfileDeviceSupportFragOrig_c        (1 << 0)
#define gFSLProfileDeviceSupportFragRecip_c       (1 << 1)
#define gFSLProfileDeviceSupportPollOrig_c        (1 << 2)
#define gFSLProfileDeviceSupportPollRecip_c       (1 << 3)
#define gFSLProfileDeviceSupportRmtPairOrig_c     (1 << 4)
#define gFSLProfileDeviceSupportRmtPairRecip_c    (1 << 5)
#define gFSLProfileDeviceSupportMenuBrowser_c     (1 << 6)
#define gFSLProfileDeviceSupportMenuOwner_c       (1 << 7)
#define gFSLProfileDeviceSupportMenuDisplayer_c   (1 << 8)
#define gFSLProfileDeviceSupportOtapServer_c      (1 << 9)
#define gFSLProfileDeviceSupportOtapClient_c      (1 << 10)

 
/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/

/* OTAMenu - Browser-Owner related commands */
typedef enum
{
  menuBrowseUp_c = 0,
  menuBrowseDown_c,
  menuBrowseLeft_c,
  menuBrowseRight_c,
  menuBrowseOk_c,
  menuBrowseExit_c,
  menuBrowseMax_c
}menuBrowseDirection_t;

/* OTAMenu - Owner-Displayer related */
typedef enum
{
  menuMessageType_Information_c = 0,
  menuMessageType_Warning_c,
  menuMessageType_Error_c,
  menuMessageType_Max_c
}menuMessageType_t;



/* Messages used for informing the application about confirms or indications from RF4CE arrived trough the NLME SAP */
typedef enum {
  /*---------------------------*/
  /* Messages to be received on the fragTx orig device */ 
  gFSLProfileFragCnf_c = 0, 
  /* Messages to be received on the fragTx recip device */ 
  gFSLProfileFragStartInd_c,
  gFSLProfileFragInd_c, 
  /*---------------------------*/
  /* Messages to be received on the poll orig device */ 
  gFSLProfilePollCnf_c, 
  gFSLProfilePollEvent_c, 
  /* Messages to be received on the poll recip device */ 
  gFSLProfilePollInd_c, 
  /*---------------------------*/
  /* Messages to be received on the remote pair orig device */ 
  gFSLProfileRmtPairCnf_c, 
  /* Messages to be received on the remote pair recip device */ 
  gFSLProfileRmtPairInd_c, 
  gFSLProfileRmtPairRspCnf_c,
  /*---------------------------*/
  /* Messages to be received on the menu browser device */ 
  gFSLProfileMenuBrowseCnf_c,
  gFSLProfileMenuBrowseCompleteInd_c,
  /* Messages to be received on the menu onwer device */ 
  gFSLProfileMenuBrowseInd_c,
  gFSLProfileDisplayMenuCnf_c,
  /* Messages to be received on the menu displayer device */ 
  gFSLProfileDisplayMenuHeaderInd_c,
  gFSLProfileDisplayMenuEntryInd_c,
  gFSLProfileDisplayMenuCompleteInd_c,
  gFSLProfileDisplayMenuMessageInd_c,
  gFSLProfileDisplayMenuExitInd_c,
  /*---------------------------*/
  /* Message to be received on all devices that support FSL private profile */
  gFSLProfileGetSupportedFeaturesCnf_c,
  /*---------------------------*/
  /* Messages to be received on the Otap server device */
  gFSLProfileOtapServerCnf_c,
  gFSLProfileOtapServerQueryNextImageInd_c,
  gFSLProfileOtapServerNextBlockReqInd_c,
  gFSLProfileOtapServerUpgradeEndReqInd_c,
  /*---------------------------*/
  /* Messages to be received on the Otap client device */
  gFSLProfileOtapClientQueryNextImgCnf_c,
  gFSLProfileOtapClientImageNotifyInd_c,
  
  
  gFSLProfileMax_c  
}fslProfileToAppMsgType_t;


/* Structure of the FSL Profile to Application SAP messages */


/* Frag service */
/*------------------------------------------------------*/
typedef struct fslProfileFragCnf_tag 
{
  uint8_t                 status;
  uint16_t                fragRxMaxAcceptedLen;
}fslProfileFragCnf_t;

typedef struct fslProfileFragStartInd_tag 
{
  uint8_t                 deviceId;
  uint16_t                fragDataLen;
}fslProfileFragStartInd_t;

typedef struct fslProfileFragInd_tag 
{
  uint8_t                 status;
  uint8_t                 deviceId;
  bool_t                  bFragSecured;  
  uint16_t                fragDataLen;
}fslProfileFragInd_t;


/* Poll service */
/*------------------------------------------------------*/
typedef struct fslProfilePollCnf_tag 
{
  uint8_t                 status;
  uint8_t                 deviceId;
} fslProfilePollCnf_t;

typedef struct fslProfilePollEvent_tag 
{
  uint8_t                 deviceId;
  bool_t                  bDataAvailable;
} fslProfilePollEvent_t;

typedef struct fslProfilePollInd_tag 
{
  uint8_t                 deviceId;
  uint16_t                rxOnInterval;
} fslProfilePollInd_t;


/* Remote pair service */
/*------------------------------------------------------*/
typedef struct fslProfileRmtPairCnf_tag 
{
  uint8_t                 status;
}fslProfileRmtPairCnf_t;

typedef struct fslProfileRmtPairInd_tag 
{
  uint8_t                 status; 
  uint8_t                 deviceId;
  uint16_t                appRspTimeOut;  
  appCapabilities_t       devAppCapabilities;
  uint8_t*                pDeviceTypeList;
  uint8_t*                pProfilesList;    
}fslProfileRmtPairInd_t;

typedef struct fslProfileRmtPairRspCnf_tag 
{
  uint8_t                 status;
  uint8_t                 deviceId;
}fslProfileRmtPairRspCnf_t;

/* OTA Menu service */
/*------------------------------------------------------*/
typedef struct fslProfileMenuBrowseCnf_tag 
{
  uint8_t                 status;
  uint8_t                 deviceId;
}fslProfileMenuBrowseCnf_t;


typedef struct fslProfileMenuBrowseCompleteInd_tag 
{
  uint8_t                 status;
  uint8_t                 deviceId;
  uint8_t                 userString[gSizeOfUserString_c];
}fslProfileMenuBrowseCompleteInd_t;

/*------------------------------------------------------*/
typedef struct fslProfileMenuBrowseInd_tag 
{
  uint8_t                 deviceId;
  menuBrowseDirection_t   direction;
  bool_t                  bUseSecurity;
}fslProfileMenuBrowseInd_t;

/*------------------------------------------------------*/
typedef struct fslProfileDisplayMenuCnf_tag 
{
  uint8_t                 status;
  uint8_t                 deviceId;
}fslProfileDisplayMenuCnf_t;

/*------------------------------------------------------*/
typedef struct fslProfileDisplayMenuHeaderInd_tag 
{
  uint8_t                 deviceId;
  uint8_t                 idxSelectedEntry;
  uint8_t                 nrMenuItemsInWindow;
  uint16_t                nrMenuItemsInMenu;
  uint16_t                firstEntryNumber;
  uint8_t                 contentType;
  uint8_t                 menuTextLength;
  uint8_t*                pMenuText;
}fslProfileDisplayMenuHeaderInd_t;

/*------------------------------------------------------*/
typedef struct fslProfileDisplayMenuEntryInd_tag 
{
  uint8_t                 deviceId;
  uint8_t                 entryIndex;
  uint8_t                 entryType;
  uint8_t                 contentType;
  uint8_t                 entryValueLength;
  uint8_t                 entryTextLength;
  uint8_t*                pEntryValue;  
  uint8_t*                pEntryText;
}fslProfileDisplayMenuEntryInd_t;

/*------------------------------------------------------*/
typedef struct fslProfileDisplayMenuCompleteInd_tag 
{
  uint8_t                 status;
  uint8_t                 deviceId;
}fslProfileDisplayMenuCompleteInd_t;

/*------------------------------------------------------*/
typedef struct fslProfileDisplayMenuMessageInd_tag 
{
  uint8_t                 deviceId;
  menuMessageType_t       messageType;
  uint8_t                 messageLength;
  uint8_t*                pMessage;
}fslProfileDisplayMenuMessageInd_t;

typedef struct fslProfileDisplayMenuExitInd_tag 
{
  uint8_t                 deviceId;
}fslProfileDisplayMenuExitInd_t;

/*------------------------------------------------------*/
typedef struct fslProfileGetSupportedFeaturesCnf_tag
{
  uint8_t                 status;
  uint8_t                 deviceId;
  uint8_t                 supportedFeaturesMap[4];
}fslProfileGetSupportedFeaturesCnf_t;

/* Otap service */
/*------------------------------------------------------*/

/* Otap server */
typedef struct fslProfileOtapServerCnf_tag 
{
  uint8_t                 status;
  uint8_t                 deviceId;
} fslProfileOtapServerCnf_t;

typedef struct fslProfileOtapServerQueryNextImageInd_tag
{
  uint8_t                 deviceId;
  uint8_t                 fileVersion[4];
  uint8_t                 hardwareVersion[2];            
}fslProfileOtapServerQueryNextImageInd_t;


typedef struct fslProfileOtapServerNextBlockReqInd_tag
{
  uint8_t                 deviceId;
  uint8_t                 fileVersion[4];
  uint8_t                 fileOffset[4];
  uint8_t                 maxDataSize;            
}fslProfileOtapServerNextBlockReqInd_t;


typedef struct fslProfileOtapServerUpgradeEndReqInd_tag
{
  uint8_t                 deviceId;
  uint8_t                 status;
  uint8_t                 fileVersion[4]; 
}fslProfileOtapServerUpgradeEndReqInd_t;


/* Otap client */
typedef struct fslProfileOtapClientQueryNextImgCnf_tag
{
  uint8_t                 status;
  uint8_t                 delayUntilUpgrade[4];
}fslProfileOtapClientQueryNextImgCnf_t;

typedef struct fslProfileOtapClientImageNotifyInd_tag 
{
  uint8_t                 deviceId;
  uint8_t                 hardwareVersion[2];
  uint8_t                 fileVersion[4];
} fslProfileOtapClientImageNotifyInd_t;



/* General structure of a message received by the application over FSL Profile SAP */
typedef struct fslProfileToAppMsg_tag 
{
  fslProfileToAppMsgType_t                  msgType;
  union {
    /*------------------------------------------------------*/
    fslProfileFragCnf_t                     fslProfileFragCnf;
    fslProfileFragStartInd_t                fslProfileFragStartInd;
    fslProfileFragInd_t                     fslProfileFragInd;
    /*------------------------------------------------------*/
    fslProfilePollCnf_t                     fslProfilePollCnf;
    fslProfilePollEvent_t                   fslProfilePollEvent;
    fslProfilePollInd_t                     fslProfilePollInd;
    /*------------------------------------------------------*/
    fslProfileRmtPairCnf_t                  fslProfileRmtPairCnf;
    fslProfileRmtPairInd_t                  fslProfileRmtPairInd;
    fslProfileRmtPairRspCnf_t               fslProfileRmtPairRspCnf;
    /*------------------------------------------------------*/
    fslProfileMenuBrowseCnf_t               fslProfileMenuBrowseCnf;
    fslProfileMenuBrowseCompleteInd_t       fslProfileMenuBrowseCompleteInd;
    fslProfileMenuBrowseInd_t               fslProfileMenuBrowseInd;
    /*------------------------------------------------------*/
    fslProfileDisplayMenuCnf_t              fslProfileDisplayMenuCnf;
    fslProfileDisplayMenuHeaderInd_t        fslProfileDisplayMenuHeaderInd;
    fslProfileDisplayMenuEntryInd_t         fslProfileDisplayMenuEntryInd;
    fslProfileDisplayMenuCompleteInd_t      fslProfileDisplayMenuCompleteInd;
    fslProfileDisplayMenuMessageInd_t       fslProfileDisplayMenuMessageInd;
    fslProfileDisplayMenuExitInd_t          fslProfileDisplayMenuExitInd;
    /*------------------------------------------------------*/
    fslProfileGetSupportedFeaturesCnf_t     fslProfileGetSupportedFeaturesCnf;
    /*------------------------------------------------------*/
    fslProfileOtapServerCnf_t               fslProfileOtapServerCnf;
    fslProfileOtapServerQueryNextImageInd_t fslProfileOtapServerQueryNextImageInd;
    fslProfileOtapServerNextBlockReqInd_t   fslProfileOtapServerNextBlockReqInd;
    fslProfileOtapServerUpgradeEndReqInd_t  fslProfileOtapServerUpgradeEndReqInd;
    fslProfileOtapClientQueryNextImgCnf_t   fslProfileOtapClientQueryNextImgCnf;
    fslProfileOtapClientImageNotifyInd_t    fslProfileOtapClientImageNotifyInd;
    
  } msgData;
}fslProfileToAppMsg_t;


/* FragTxRx buffer states */
typedef enum
{
  gFragTxRxBufferFree_c, 
  gFragTxRxBufferBusyApp_c, 
  gFragTxRxBufferBusyProfile_c
} fslProfileFragTxRxBufferState_t;


/* OTAP commands list */
typedef enum fslProfileOtapServerCommand_tag
{
  gFslProfileOtapImageNotifyCmd = 0,
  gFslProfileOtapQueryNextImageRespCmd,
  gFslProfileOtapNextBlockRespCmd,
  gFslProfileOtapUpgradeEndRespCmd,
}fslProfileOtapServerCommand_t;


/* Image Notify */
typedef struct imageNotify_tag
{
  uint8_t                 jitterVal;
  uint8_t                 hardwareVersion[2];
  uint8_t                 fileVersion[4];
}imageNotify_t;

/* Query commands status codes */
typedef enum queryCmdStatusCode_tag
{
  gFslProfile_Success=0,
  gFslProfile_NotAuthorized=0x7E, 
  gFslProfile_NotImageAvailable=0x95  
}queryCmdStatusCode_t;


/* Query Next Image Response command frame*/
typedef struct queryNextImgResp_tag
{
  queryCmdStatusCode_t   status;
  uint8_t                 fileVersion[4];
  uint8_t                 imageSize[4];
  uint8_t                 crc[4];
  uint8_t                 bitmapLength;

  uint8_t                 bitmap[32];

}queryNextImgResp_t;


/* Image block response status codes */
typedef enum nextBlockStatusCode_tag
{
  gFslProfile_BlockStateSuccess=0,
  gFslProfile_BlockStateAbort=0x92,
}nextBlockStatusCode_t;


/* Image Block Response command frame */
typedef struct imageBlockResp_tag
{
  nextBlockStatusCode_t   status;
  uint8_t                 fileOffset[4];
  uint8_t                 dataSize;
  uint8_t*                pData;                    
}imageBlockResp_t;

/* Otap Upgrade End Responsee command frame */
typedef struct upgradeEndResp_tag
{
  uint8_t                 delayUntilUpgrade[4];
}upgradeEndResp_t;  

/* App to Otap comands */
typedef struct fslProfileApptoOtapCmd_tag 
{
  fslProfileOtapServerCommand_t   cmdType;
  union {
  
    imageNotify_t           imageNotify;
    queryNextImgResp_t      queryNextImgResp;
    imageBlockResp_t        imageBlockResp;
    upgradeEndResp_t        upgradeEndResp; 
  } cmdData;
}fslProfileApptoOtapCmd_t;

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

 
/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/


/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

/************************************************************************************
* FSLProfile_FragTxRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_FragTxRequest(uint8_t deviceId, uint16_t dataLen,uint8_t *pData, bool_t bUseSecurity);

/************************************************************************************
* FSLProfile_SetFragTxRxBufferStateRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_SetFragTxRxBufferStateRequest(fslProfileFragTxRxBufferState_t newBufferState);

/************************************************************************************
* FSLProfile_GetFragTxRxBufferStateRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   FragTxRx buffer state
* 
************************************************************************************/
fslProfileFragTxRxBufferState_t FSLProfile_GetFragTxRxBufferStateRequest(void);

/************************************************************************************
* FSLProfile_PollConfig
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_PollConfigRequest(uint32_t pollInterval, uint16_t rxOnInterval);

/************************************************************************************
* FSLProfile_PollRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_PollRequest(uint8_t deviceId, bool_t bPollEnable);

/************************************************************************************
* FSLProfile_PollDataAvailable
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_PollDataAvailable(uint8_t deviceId, bool_t bDataAvailable);

/************************************************************************************
* FSLProfile_RmtPairRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_RmtPairRequest(
                                  uint16_t          appRecipRspTimeOut,
                                  uint8_t           deviceId1, 
                                  appCapabilities_t dev1AppCapabilities, 
                                  uint8_t*          pDev1DeviceTypeList,
                                  uint8_t*          pDev1ProfileIdList, 
                                  uint8_t           deviceId2, 
                                  appCapabilities_t dev2AppCapabilities, 
                                  uint8_t*          pDev2DeviceTypeList,
                                  uint8_t*          pDev2ProfileIdList
                                 );

/************************************************************************************
* FSLProfile_RmtPairResponse
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_RmtPairResponse(uint8_t status);


/************************************************************************************
* FSLProfile_MenuBrowseRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_BrowseMenuRequest(uint8_t deviceId, menuBrowseDirection_t direction, bool_t bUseSecurity);


/************************************************************************************
* FSLProfile_DisplayMenuHeaderRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_DisplayMenuHeaderRequest(uint8_t   deviceId, 
                                            bool_t    bUseSecurity,
                                            uint8_t   idxSelectedEntry,
                                            uint8_t   nrMenuItemsInWindow,
                                            uint16_t  nrMenuItemsInMenu,
                                            uint16_t  firstEntryNumber,
                                            uint8_t   contentType,
                                            uint8_t   menuTextLength,
                                            uint8_t*  pMenuText);


/************************************************************************************
* FSLProfile_DisplayMenuEntryRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_DisplayMenuEntryRequest( uint8_t   deviceId,
                                            bool_t    bUseSecurity,
                                            uint8_t   entryIndex,
                                            uint8_t   entryType,
                                            uint8_t   contentType,
                                            uint8_t   entryValueLength,
                                            uint8_t   entryTextLength,
                                            uint8_t*  pEntryValue,  
                                            uint8_t*  pEntryText);
                                            
                                            
/************************************************************************************
* FSLProfile_DisplayMenuMessageRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_DisplayMenuMessageRequest(uint8_t           deviceId,
                                             bool_t            bUseSecurity,
                                             menuMessageType_t messageType,
                                             uint8_t           messageLength,
                                             uint8_t*          pMessage);
                                            

/************************************************************************************
* FSLProfile_DisplayCompleteIndToBrowserRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_DisplayCompleteIndToBrowserRequest(uint8_t browserDeviceId,
                                                      uint8_t displayerDeviceId,
                                                      bool_t  bUseSecurity,
                                                      uint8_t status);




/************************************************************************************
* FSLProfile_DisplayMenuExitRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_DisplayMenuExitRequest(uint8_t deviceId,
                                          bool_t  bUseSecurity);


/************************************************************************************
* FSLProfile_InitOtapServerProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitOtapServerProcedure(void);


/************************************************************************************
* FSLProfile_InitOtapClientProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitOtapClientProcedure(void);


/************************************************************************************
* FSLProfile_InitFragTxOrigProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitFragTxOrigProcedure(void);


/************************************************************************************
* FSLProfile_InitFragTxRecipProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitFragTxRecipProcedure(void);


/************************************************************************************
* FSLProfile_InitPollOrigProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitPollOrigProcedure(void);


/************************************************************************************
* FSLProfile_InitPollRecipProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitPollRecipProcedure(void);


/************************************************************************************
* FSLProfile_InitRmtPairOrigProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitRmtPairOrigProcedure(void);


/************************************************************************************
* FSLProfile_InitRmtPairRecipProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitRmtPairRecipProcedure(void);


/************************************************************************************
* FSLProfile_InitMenuBrowserProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitMenuBrowserProcedure(void);


/************************************************************************************
* FSLProfile_InitMenuOwnerLightProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitMenuOwnerLightProcedure(void);


/************************************************************************************
* FSLProfile_InitMenuDisplayerProcedure
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_InitMenuDisplayerProcedure(uint16_t waitMenuEntryTimeout);


/************************************************************************************
* FSLProfile_GetSupportedFeatures
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t FSLProfile_GetSupportedFeatures(uint8_t deviceId, bool_t bUseSecurity);


/************************************************************************************
* FSLProfile_IsIdle
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
bool_t FSLProfile_IsIdle(void);


/************************************************************************************
* FSLProfile_HandleNwkNldeMsg
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
void FSLProfile_HandleNwkNldeMsg(nwkNldeToAppMsg_t *pMsg);


/************************************************************************************
* FSLProfileToApp_SapHandler
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
void FSLProfile_App_SapHandler(fslProfileToAppMsg_t* fslProfileToAppMsg);

/************************************************************************************
* FSLProfile_OtapServerSend
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
uint8_t FSLProfile_OtapServerSend(uint8_t deviceId,fslProfileApptoOtapCmd_t* otapCmdMsg);

/************************************************************************************
* FSLProfile_OtapQueryNextImageRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
uint8_t FSLProfile_OtapQueryNextImageRequest(uint8_t deviceId,const uint8_t fileVersion[4],const uint8_t hardwareVersion[2]);

#endif  /* _FSL_PROFILE_INTERFACE_H_ */
